/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class MixinCampfire {
    @Inject(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at={@At(value="HEAD")})
    private static void onItemCook(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo ci) {
        double waterskinStrength = ConfigSettings.WATERSKIN_STRENGTH.get().intValue();
        double tempRate = ConfigSettings.TEMP_RATE.get();
        for (int i = 0; i < blockEntity.m_59065_().size(); ++i) {
            ItemStack stack = (ItemStack)blockEntity.m_59065_().get(i);
            if (!stack.m_150930_(ModItems.FILLED_WATERSKIN) || (level.m_46467_() & 4L) != 0L) continue;
            CompoundTag tag = stack.m_41784_();
            double temperature = tag.m_128459_("Temperature");
            if (state.m_204336_(BlockTags.f_13087_) && CSMath.getIfNotNull(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()), ResourceLocation::toString, "").contains("soul") && tag.m_128459_("Temperature") > -waterskinStrength * 0.6) {
                tag.m_128347_("Temperature", temperature + tempRate * 0.1 * (double)(ConfigSettings.COLD_SOUL_FIRE.get() != false ? -1 : 1));
                continue;
            }
            if (!state.m_204336_(BlockTags.f_13087_) || !(tag.m_128459_("Temperature") < waterskinStrength * 0.6)) continue;
            tag.m_128347_("Temperature", temperature + tempRate * 0.1);
        }
    }

    @ModifyArg(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Containers;dropItemStack(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"), index=4)
    private static ItemStack onItemFinishedCooking(Level level, double x, double y, double z, ItemStack result) {
        if (result.m_150930_(ModItems.FILLED_WATERSKIN)) {
            double waterskinStrength = ConfigSettings.WATERSKIN_STRENGTH.get().intValue();
            CompoundTag tag = result.m_41784_();
            BlockState state = level.m_8055_(new BlockPos(x, y, z));
            if (state.m_204336_(BlockTags.f_13087_) && CSMath.getIfNotNull(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()), ResourceLocation::toString, "").contains("soul")) {
                tag.m_128347_("Temperature", waterskinStrength * 0.6 * (double)(ConfigSettings.COLD_SOUL_FIRE.get() != false ? -1 : 1));
            } else if (state.m_204336_(BlockTags.f_13087_)) {
                tag.m_128347_("Temperature", waterskinStrength * 0.6);
            }
        }
        return result;
    }
}

